// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : EntityFish.cpp
// Date           : February 2008
//
// Description    : This file defines the EntityFish class for the user's
//                  controllable avatar.  Once instantiated, the primary
//                  methods for control are Jump(), Run() and Drop().  The
//                  game loop (via CGame) must check IsDead() to determine
//                  if the player has died.
//
// ///////////////////////////////////////////////////////////////////////////
#pragma once



#include "entity.h"
#include "text.h"






class EntityFish : public Entity 
{

  public:

    float                   m_JumpStartY;
    float                   m_JumpDelay;
    bool                    m_InsideWater;


    EntityFish( Dobbs::EntityTypes EType );
    ~EntityFish();


    virtual void            OnEvent( const EntityEvent Event, int Param1, int Param2, const std::string& TextParam, Entity* pEntity );

    void                    UpdateTimed( Level& aLevel, float ElapsedTime );

    void                    Splash();

};

